function [y,fs,nbits]=ByzantineMonochord(Ni_freq,period,mel,a)

% Program to play the Byzantine Music notes, 
% by Panayiotis D. Papadimitriou (panayiotis@analogion.net), 2003-2005.
%
%

clc
strstart = strvcat(' ',...
' ------------------------------------------------------  ',...
'              , v.1.1                  ',...
'             Byzantine Monochord, v.1.1                  ',...
' ------------------------------------------------------  ',...
'    . , 2003-2006.          ',...
' by Panayiotis D. Papadimitriou, 2003-2006.              ',...
' [panayiotis@analogion.net]                              ',...
'                                                         ',...
' NO WARRANTY                                             ',...
' Unless otherwise noted, all source code in this file         ',...        
' is public domain, and may be freely distributed,        ',...
' and used without modifications, as long                 ',...
' as a scientific reference to us is given, as:           ',...
' Panayiotis D. Papadimitriou, Byzantine Monochord, v.1.1.',...
'  . ,  , v.1.1.',...
'                                                         ',...
' IT COMES WITH ABSOLUTELY NO WARRANTY OF ANY KIND.       ',...
' ------------------------------------------------------  ',...
'                                                          ',...
' /Notes:                                                   ',...
' -  e    ',...
' -  T      /period     /sec.',...
' -  F           Hz.',...
' ',' ',' ',...
'       ',...
'    ,    .',...
'      .',...
' ',' ',' ');

% ' - to write the sound into a .wav file:                   ',...
% '   wavwrite(y,fs,nbits,''filename.wav'')                  ',...
% ' -     .',...
% ' -  s   ,    .',...
% ' - not finished----under test---    (z,x,c,...)       .',...
% ' -  J    -          .wav .',...
% ' -  S........',...


disp(strstart);
input('  .     ...');


%
Ni_freq=440/(3/2*9/8);
period=0.5;
mel=0;
a='nN';
a0 = a;

%global strings
global pdplogo;
global str_palianea;

%english is the most updated!
lang=3;1;     %1: greek, 2: greek-lish, 3: english

%define strings
if lang==1, %1: greek, 
    pdplogo = sprintf('\n .  (panayiotis@analogion.net), 2003-2005.');    
    str_Dialeje = sprintf('\n\n[0] ()\n[1-8] \n------------\n[30] ( 1881)\n[31] ()\n[40] 12-10-8, .\n[80] 2-2-1 .\n\n: ');
    stra8 = sprintf('\n'' . ''.\n1. \n2. :     \n3.  : ''    . ''.\n  [1-3]: ');    
    str_palianea = ',  ,  ';
    str_allaghKlimakoslogwFthoras = '   ...';
elseif lang ==2, %2: greek-lish
    pdplogo = sprintf('\nPanayiotis D. Papadimitriou (panayiotis@analogion.net), 2003-2005.');    
    str_Dialeje = sprintf('\nDialexe\n[0] (arxikh)\n[1-8] hxo\n------------\n[30] (Epitropi 1881)\n[31] (Chrysan0ou)\n[40] 12-10-8 klp.\n[80] 2-2-1 klp.\n\n: ');
    stra8 = sprintf('\nHxos pl. d''.\n1. diatonikos\n2. triphwnia: Ga->Ni\n3. fthora nenanw: Ni'' -> Di pl. b''.\nDialeje klimaka [1-3]: ');    
    str_palianea = 'f0oggos,  Didimos, nea klimaka';    
    str_allaghKlimakoslogwFthoras = 'allagh klimakos logw fthoras...';    
else    %3: english
    copyrightlogo = strvcat('------------------------------------------------------------------------',...
                            '                          , v.1.1                  ',...
                            '                         Byzantine Monochord, v.1.1                ',...
                            '------------------------------------------------------------------------');
%     pdplogo = sprintf('\nPanayiotis D. Papadimitriou (panayiotis@analogion.net), 2003-2006.');    
    pdplogo = sprintf('\n .  (panayiotis@analogion.net), 2003-2006.');    
    str_Dialeje = sprintf('\n*** /Menu:*** \n\n[0] (/initial)\n------------');
    str_Dialeje = [str_Dialeje, sprintf('\n[1-8] /Modes 1-8\n           :\n      --/Didymos (1 .),\n      --/Committee 1881,\n      --/Committee 1881,\n      --/')];
    str_Dialeje = [str_Dialeje, sprintf('\n------------\n[30]   /Committee 1881:\n      -')];
    str_Dialeje = [str_Dialeje, sprintf('\n------------\n[31] A   ')];    
    str_Dialeje = [str_Dialeje, sprintf('\n------------\n[40]  (72 )  /Committee 1881:\n      - (12-10-8...), , , \n      -, , )')];
    str_Dialeje = [str_Dialeje, sprintf('\n------------\n[80]    ( ), 2-2-1 .')];
    str_Dialeje = [str_Dialeje, sprintf('\n------------\n\n\n/Choose : ')];    
    stra1 = sprintf('\n ''/Mode 1st.\n\n1. /Diatonic\n2. Ke->Di Neanes (Ton Tafon Sou)\n');                
    stra2 = sprintf('\n ''/Mode 2nd.\n\n1. Di Neanes\n2. Bou Neanes -> Pa Nexeanes (e.g. antiphons)\n3. Di Neanes -> Pa Nexeanes (e.g. Cherouvikon Fokaeos)\n4. Ke Neanes -> Ga diatonikos (e.g. Poiois eufhmiwn)\n');
    stra3 = sprintf('\n ''/Mode 3rd.\n\n1. /Diatonic\n2. Enarmonios (theoretical)\n3. Papadic (Ga -> Ni)\n4. Troxos, high troxos Ke->Pa\n');    
    stra4 = sprintf('\n ''/Mode 4th.\n\n1. /Diatonic\n2. Troxos, high troxos Ke->Pa\n3. Agia (Zo'' enarm., Ke yphesis)\n4. Nenanw fthora: Ni'' diatonic -> Di Nexeanes\n');
    stra5 = sprintf('\n . ''/Mode pl. 1st.\n\n1. /Diatonic\n2. Troxos, high troxos Ke->Pa\n');
    stra6 = sprintf('\n . ''/Mode pl. 2nd.\n\n1.   (Pa Nexeanes)\n2.   ->   (Pa Nexeanes -> Bou Neanes)\n3.   ->   (Ga Nexeanes -> Bou Neanes)\n4.   (Di Neanes)\n5. /Diatonic\n');
    stra7 = sprintf('\n /Mode Varis.\n\n1. /Diatonic\n2. zw -> Bou Neanes\n');
    stra8 = sprintf('\n . ''/Mode pl. 4th.\n\n1. /Diatonic\n2. triphonia: Ga->Ni\n3. fthora nenanw: Ni''-> Di of pl. 2nd.\n');    
    str_notesbefc = sprintf('\n-/Note:\n       ''j''  ''  (-=256/243), \n    ''f''      (  , -=256/243)');
    strachoose = sprintf('\n\n\n /Choose Scale [1,2,...] : ');
    stra1881  = sprintf('\nCommitee 1881.\n1. /diatonic [9/8 - 800/729 - 27/25] \n2. --\n\n /Choose Scale : ');
    straChrys = sprintf('\nChrysanthos.  \n1. /diatonic [9/8 - 12/11 - 88/81]   \n2. --\n\n /Choose Scale : ');
    straSigkCom = sprintf('\nSigkerasmeni Scale of Committee 1881.\n1. Ni-12-10-8 -12-12-10-8 -Ni'' (diatonic)\n2. Ni-8 -14-8 -12-8 -14-8 -Ni'' (neanes or "soft" chromatic)\n3. Pa-6 -20-4 -12-6 -20-4 -Pa'' (nexeanes or "hard" ("sintonos") chromatic)\n4. Ga-12-12-6 -12-12-12-6 Ga''  (enarmonion)\n5. Ni-18-4 -16-4 -Di  (zygos)\n6. Ni-12-14-12-4 -Di  (kliton)\n7. Ga-20-4 -4 -14-Ni'' (spathi)\n--\n\n /Choose Scale [1-7]: ');
    straEuro = sprintf('\nEuropean Intervals. Given just for comparison.\n1. 2-2-1-2-2-2-1\n2. --\n\n /Choose Scale : ');
    str_palianea = sprintf('Notes     Didymos  | Notes  current\n         diatonic  |          Scale\n-----------------------------------');
    str_allaghKlimakoslogwFthoras = 'Scale change due to fthora...';
end




s=sprintf('-----------------------------------------------\n\n');disp(s)

%parameters
fs=22050;   %11025
nbits=16;
tstep=1/fs;

%original
armonikes_amplitude=[ 
    100,1
    39,2
    23,3
    17,4
    7,5];                       %dB or amplitude, xtimes of the basic frequency

%GKMichalakis; (:,1) in dB - shifted by one harmonic :)
armonikes_amplitude=[ 
    1,1
    1,2
    -14,3
    -15,4
    -18,5
    -10,6
    0,7
    -19,8
    -31,9
    -21,10
    -17,11]; armonikes_amplitude(:,1) = 10.^(armonikes_amplitude(:,1)/20);  %dB->amplitude, xtimes of the basic frequency

ampl=armonikes_amplitude(:,1);  %normalize amplitudes of  harmonices
ampl=ampl/sum(ampl);


while 1,
    
    clc;
    flag_breakhxos0 =0;
    disp(copyrightlogo);
    disp(pdplogo);
    hxos = input(str_Dialeje);
    clc;
    disp(pdplogo);    
    
    while 1,
        if hxos == 0,
            if flag_breakhxos0 == 1,
                break;
            end
            a = a0;
        elseif hxos == 1,
            clc;
            disp(pdplogo); 
            stra = sprintf('%s%s%s',stra1,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice            
                case '1'
                    a = 'vV';       %a': diatonikos'
                case '2' 
                    a = ',<V 2';    %a': ->  (   )
                otherwise
                    choice = '1';
                    a = 'vV';       %a': diatonikos'
            end        
        elseif hxos == 2,
            clc;
            disp(pdplogo);                            
            stra = sprintf('%s%s%s',stra2,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice            
                case '1'
                    a = 'm<?';       %'
                case '2'
                    a = 'b<? !';     %   '     . ' (, ).
                case '3'
                    a = 'm<? !';     %Di Neanes -> Pa Nexeanes (e.g. Cherouvikon Fokaeos)
                case '4'
                    a = 'm<?1 h';     %Ke Neanes -> Ga Diatoniko (e.g. poiois eufhmiwn - Stefanou) 
                otherwise
                    choice = '1';
                    a = 'm<?';       %'
            end        
        elseif hxos == 3,
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra3,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice            
                case '1'
                    a = 'nN';       %': 
                case '2' 
                    a = 'nn';       %: .  - 
                case '3'
                    a = 'nN D';     %':  (    -)
                case '4'
                    a = 'nN2 f';    %':   ->
                otherwise
                    choice = '1';
                    a = 'nN';       %': 
            end    
        elseif hxos == 4,
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra4,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice            
                case '1'
                    a = 'm<C';      %diatonikos
                case '2'
                    a = 'm<C1 f';   %troxos pros ta panw, dhl. ton Ke ton kanw Pa.
                case '3'
                    a = 'm<C3 J';   %d' Agia: xarakthristikh klimaka (Zw' enarmonios, Ke ufesis)
                case '4'
                    a = 'm<C3 ^';   %f0ora nenanw: ton Ni' tou diatonikou ton kanei Di pl. b' (Xer. Fwkaews)
                otherwise
                    choice = '1';
                    a = 'm<C';      %diatonikos
            end
        elseif hxos == 5,
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra5,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice            
                case '1'
                    a = 'vV';       %pl. a': diatonikos'
                case '2'
                    a = 'vV4 a';    %pl. a': pseudo-troxos, giati katebainei katw tou Pa (ton Ke ton kanw Pa).
                otherwise
                    choice = '1';
                    a = 'vV';       %pl. a': diatonikos'
            end
        elseif hxos == 6,
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra6,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice            
                case '1'
                    a = 'v?';       %pl. b'
                case '2'
                    a = 'v? 2 B';   %  ->  
                case '3'            
                    a= 'v?2 2 B';   %Ga Nexeanes -> Bou Neanes                 
                case '4'
                    a = 'm<?';       %' -  
                case '5'
                    a = 'vV';       %pl. ': diatonik
                otherwise
                    choice = '1';
                    a = 'v?';       %pl. b'
            end
        elseif hxos == 7,
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra7,str_notesbefc,strachoose);
            choice = input(stra,'s');            
            if choice=='e',
                break;
            end            
            switch choice     
                case '1'
                    a = '.>';       %: .
                case '2'
                    a = '.>0 W B';  %:      .
                otherwise
                    choice = '1';
                    a = '.>';       %: .
            end
        elseif hxos == 8,          
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra8,str_notesbefc,strachoose);
            choice = input(stra,'s');             
            if choice=='e',
                break;
            end            
            switch choice     
                case '1'
                    a = 'cC';       %. ': .
                case '2'
                    a = 'nN D';     %. ':     .
                case '3'
                    a = 'm<C3 ^';   %. ': f0ora nenanw: ton Ni' ton kanei Di pl. b' (Xer. Fwkaews)
                otherwise
                    choice = '1';
                    a = 'cC';       %. ': .
            end
        elseif hxos == 30,          % 1881.
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',stra1881);
            choice = input(stra,'s');                        
            if choice=='e',
                break;
            end    
            switch choice     
                case {'1'}
                    temp = 1;   %aplh grammh kwdika.
                otherwise
                    choice = '1';
            end            
            scale = load_special_scales(hxos,choice,Ni_freq);       
        elseif hxos == 31,          %.
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',straChrys);
            choice = input(stra,'s');                        
            if choice=='e',
                break;
            end  
            switch choice     
                case {'1'}
                    temp = 1;   %aplh grammh kwdika.
                otherwise
                    choice = '1';
            end                        
            scale = load_special_scales(hxos,choice,Ni_freq);       
        elseif hxos == 40,          %12-10-8 ktl.
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',straSigkCom);
            choice = input(stra,'s');                        
            if choice=='e',
                break;
            end            
            switch choice     
                case {'1','2','3','4','5','6','7'}
                    temp = 1;   %aplh grammh kwdika.
                otherwise
                    choice = '1';
            end                                    
            scale = load_special_scales(hxos,choice,Ni_freq);                   
        elseif hxos == 80,          %2-2-1 ktl.
            clc;
            disp(pdplogo);                
            stra = sprintf('%s%s%s',straEuro);
            choice = input(stra,'s');                        
            if choice=='e',
                break;
            end            
            switch choice     
                case {'1'}
                    temp = 1;   %aplh grammh kwdika.
                otherwise
                    choice = '1';
            end                                    
            scale = load_special_scales(hxos,choice,Ni_freq);                   
        else    %wrong selection.
            clc;
            break;
        end
                
        %bres klimaka.
        if hxos < 30,
            % , , .
            [f0oggoi,f0oggoi_str,frequencies,duration,amplitude,scale,scale0,startmode,f0oggosTe0hkeHfthora,f0oggos_f0oras]=convert_char_to_f0oggous(a,Ni_freq);                        
        else
            scale0 = scale;
            startmode = hxos;
        end
        
        %initial display of the scale.
        klimaka_fthoras = -1;
        if norm(scale-scale0)~=0 & hxos~=0,
            disp(str_allaghKlimakoslogwFthoras);
            klimaka_fthoras=print_klimaka(scale,scale0,f0oggosTe0hkeHfthora,f0oggos_f0oras); disp(klimaka_fthoras)
        else
            if startmode ~= 8,
                scaletemp=get_scale(8,Ni_freq);
                klimaka=print_klimaka(scale,scaletemp); 
            else
                klimaka=print_klimaka(scale); 
            end
            disp(klimaka)            
        end
        
        
        
        while 1,
            
            wrong_key = 0;
            if hxos~=0,
                if hxos>=1 & hxos<=8,
                    strk = sprintf('hxos %d(%s) - f0oggoi: ',hxos,choice);
                else
                    strk = sprintf('Epilogi %d(%s) - f0oggoi: ',hxos,choice);
                end
            else
                strk = 'f0oggoi : ';
            end            
            a = input(strk,'s');    
            disp('--------------------------');
            if a=='e'
                if hxos == 0,
                    flag_breakhxos0 =1;
                end
                break;
            elseif a=='T',
                stemp = sprintf('\nGive period [sec]: ');
                period = input(stemp);
                disp('');
                a='';
            elseif a=='F',
                stemp = sprintf('\nGive frequency of Ni [Hz]: ');
                Ni_freq = input(stemp);
                break;  %reset.
            end
            N=length(a);    
            if N>0,
                f0oggoi=[];
                f0oggoi_iso=[];                
                duration=[];
                frequencies=[];    
                frequencies_iso=[];                    
                j=1;
                i=1;
                save_a_flag = 0;
                gorgon = 0;
                prev_iso_pos = 0;
                
                while (j<=N)
                    
                    ufesis = 0;        
                    
                    switch a(j)            
                        case {'1'}    %di
                            f0oggoi(i)=1;
                        case {'q'}    %di
                            f0oggoi(i)=2;
                        case {'a'}    %di
                            f0oggoi(i)=3;
                        case {'z'}    %Ni
                            f0oggoi(i)=4;
                        case {'x'}    %Pa
                            f0oggoi(i)=5;
                        case {'c'}    %Bou
                            f0oggoi(i)=6;
                        case {'f'}    %Bou diesis = Ga / (256/243),  ufesis = -1, means diesis.
                            f0oggoi(i)=6;                
                            ufesis = -1;
                        case {'v'}    %Ga
                            f0oggoi(i)=7;
                        case {'b'}    %Di
                            f0oggoi(i)=8;
                        case {'n'}    %Ke
                            f0oggoi(i)=9;
                        case {'m'}    %Zw'
                            f0oggoi(i)=10;
                        case {'j'}    %Zw' ufesis = Ke * (256/243)
                            f0oggoi(i)=10;                
                            ufesis = 1;
                        case {','}    %Ni'
                            f0oggoi(i)=11;
                        case {'.'}    %Pa'
                            f0oggoi(i)=12;
                        case {'/'}    %Bou'
                            f0oggoi(i)=13;
                        case {''''}    %Ga'
                            f0oggoi(i)=14;
                        case {']'}    %Di'
                            f0oggoi(i)=15;
                        case {'s'}      %
                            gorgon = 1;
                        case {'I'}      %
                            gorgon = 1;  
                            %not finished.
                        case{'S'}
                            save_wav(scale,fs,nbits,period,armonikes_amplitude,ampl);
                            return;
                        case{'J'}
                            save_a_flag = 1;
                            break;      %actually breaks from 'while (j<=N)'
                        otherwise 
                            wrong_key = 1;
                            f0oggoi(i)= 1;  %just for no error.
                            s = sprintf('\n\n Wrong key: %s\n-----------------------------\n',a(j));
                            disp(s)
                    end
                                                           
                    %  .
                    if gorgon == 1,
                        i=i-1;
                        duration(i)=1/2;
                        duration(i-1)=1/2;   
                        gorgon = 0;
                    else
                        frequencies(i)=scale(f0oggoi(i));       
                        duration(i)=1;
                        frequencies(i) = check_ufesis(ufesis,scale,frequencies(i),f0oggoi(i));
                    end
                    j=j+1;
                    i=i+1;            
                end
                
                %display klimaka
                if klimaka_fthoras ~= -1,
                    disp(pdplogo);disp(' ');
                    disp(klimaka_fthoras)
                else
                    if startmode ~= 8,
                        scaletemp=get_scale(8,Ni_freq);
                        klimaka=print_klimaka(scale,scaletemp); 
                    else
                        klimaka=print_klimaka(scale); 
                    end
                    disp(klimaka)
                end
                                
                count=length(f0oggoi);
                amplitude=ones(count,1);
                
                % 
                if mel==1,
                    [frequencies]=put_melwdikes_eljeis(f0oggoi,frequencies,startmode);
                end
                
                y=[];
                for i=1:length(frequencies),
                    t=0:1/fs:duration(i)*period-1/fs;
                    waveform=zeros(1,length(t));
                    for j=1:length(armonikes_amplitude),        
                        waveform=waveform+ampl(j)*sin(2*pi*frequencies(i)*armonikes_amplitude(j,2)*t);
                    end
                    y=[y, amplitude(i)*waveform];
                end
                
                %if no wrong key was heated, play it.
                if wrong_key ~= 1,                    
                    wavplay(y,fs);
                    %     sound(y,fs);
                    if save_a_flag == 1,        %save also
                        wavwrite(y,fs,nbits,'save.wav');
                    end
                end
            end
        end
    end
end





%------------------------------------------------------
%check_ufesis

function frequency2 = check_ufesis(ufesis,scale,frequency,f0oggos)

if ufesis ==1,
    if f0oggos == 10,   %Zw' ufesis
        frequency2 = scale(f0oggos-1)*(256/243);    
    end
elseif ufesis ==-1,
    if f0oggos == 6,   %Bou diesis
        frequency2 = scale(f0oggos+1)/(256/243);    
    end
else
    frequency2 = frequency;
end



%--------function to convert characters to f0oggous

function [f0oggoi,f0oggoi_str,frequencies,duration,amplitude,scale,scale0,startmode,f0oggosTe0hkeHfthora,f0oggos_f0oras]=convert_char_to_f0oggous(a,Ni_freq)

f0oggosTe0hkeHfthora = -1;
f0oggos_f0oras = -1;

N=length(a);

f0oggoi=[];
duration=[];
frequencies=[];

f0ora=0;

%get bash -----------------.
j=1;
i=1;

%check f0oggo (ED Psaltica 97)!
switch a(j)
    case '.'                %    .
        f0oggoi(i)=3;
        if a(j+1) == '/',
            f0oggoi(i) = 10;
            j=j+1;
        end
    case 'c'                %katw Ni
        f0oggoi(i)=4;
    case 'v'
        f0oggoi(i)=5;
    case 'b'
        f0oggoi(i)=6;
    case 'n'				%katw Ga
        f0oggoi(i)=7;
    case 'm'
        f0oggoi(i)=8;       % 
    case ','
        f0oggoi(i)=9;
    otherwise 
        temp=input('Prepei na baleis bash (Ni-Zw'')! Pata CTRL-C');
end

j=j+1;

%  (ED Psaltica 97)!
switch a(j)
    case {'>'}          % 
        mode=8;    
    case {'C','V'}      %diatonikos 
        mode=8;
    case {'B'}      	%diatonikos ,  '
        mode=8;        
    case {'N'}      	%diatonikos 
        mode=8;
    case {'<'}      	%diatonikos    (  ').
        if a(j+1) == '?',
            mode=2;
        else
            mode=8;        
        end
        j=j+1;
    case {'?'}          %Nexeanes parrhlagmenon,  . 193.
        mode=6;        
    case {'M'}          %nenanw
        mode=6;
    case {'n'};         %  ,   '  ,  ,  Excel.
        mode=3;
    otherwise
        temp=input('Prepei na baleis f0ora sthn arxh! Pata CTRL-C');
end    
startmode=mode;
scale=get_scale(mode,Ni_freq);
scale0=scale;
j=j+1;
i=i+1;    

while (j<=N)
    
    f0ora=0;
    poiothta=0;
    endiamesh_marturia=0;
    sun0eto_f0oggoshmo=0;
    
    %check (ED Psaltica 97)!    
    %to ED Psaltica 97 exei sto 0 to 'ison', sto 1 to 'oligon', sto 2
    %anabash duo fwnwn k.o.k.
    switch a(j)
        
        % - ED Psaltica 97
        case {'0','p'}                              %p:  
            f0oggoi(i)=f0oggoi(i-1);
            
            %  - ED Psaltica 97
        case {'1','q','`'}                          %q:, `:
            f0oggoi(i)=f0oggoi(i-1)+1;
        case {'2','w'}
            f0oggoi(i)=f0oggoi(i-1)+2;
        case {'3','e'}
            f0oggoi(i)=f0oggoi(i-1)+3;
        case {'4','r'}
            f0oggoi(i)=f0oggoi(i-1)+4;
        case {'5','t'}
            f0oggoi(i)=f0oggoi(i-1)+5;
        case {'6','y'}
            f0oggoi(i)=f0oggoi(i-1)+6;
        case {'7','u'}
            f0oggoi(i)=f0oggoi(i-1)+7;
            
            %   - ED Psaltica 97
        case {'O'}                                  %O:   .
            f0oggoi(i)  =f0oggoi(i-1)+1;
            f0oggoi(i+1)=f0oggoi(i)  +1;
            sun0eto_f0oggoshmo=1;
            
            %f0oggoshma katabashs - ED Psaltica 97            
        case '!'
            f0oggoi(i)=f0oggoi(i-1)-1;
        case '@'
            f0oggoi(i)=f0oggoi(i-1)-2;
        case '#'
            f0oggoi(i)=f0oggoi(i-1)-3;
        case '$'
            f0oggoi(i)=f0oggoi(i-1)-4;
        case '%'
            f0oggoi(i)=f0oggoi(i-1)-5;
        case '^'
            f0oggoi(i)=f0oggoi(i-1)-6;
        case '&'
            f0oggoi(i)=f0oggoi(i-1)-7;            
            
            %  - ED Psaltica 97
        case {'''','+','{','\'}                               %pshfiston=',+,o={,=\
            poiothta=1;
            
            %    - ED Psaltica 97
        case {'c','C','v','V','b','B','n','N','m','C','<',',','.','/','M','>','?'}         %cCvVbBnNmC<,./M>?
            endiamesh_marturia=1;
            
        otherwise %tote einai shmadi f0oras!
            f0ora=1;
            [scale,frequencies,j,f0oggosTe0hkeHfthora,f0oggos_f0oras]=check_f0ora(scale,mode,a,f0oggoi,frequencies,i,j,Ni_freq);            
    end
    
    if poiothta==1,
        j=j+1;        
    elseif endiamesh_marturia==1,
        j=j+1;
    elseif f0ora==0 & sun0eto_f0oggoshmo==1,
        %  .
        frequencies(i)=scale(f0oggoi(i));
        frequencies(i+1)=scale(f0oggoi(i+1));
        
        duration(i)=1;
        duration(i+1)=1;

        j=j+1;
        i=i+2;        
    elseif f0ora==0,
        %  .
        frequencies(i)=scale(f0oggoi(i));
        
        %check the klasma and diplh.
        if j~=N & (a(j+1)=='a' | a(j+1)=='A' | a(j+1)=='z' | a(j+1)=='Z'),  %klasma
            duration(i)=2;
            j=j+1;
        elseif j~=N & a(j+1)=='k',                                          %diplh
            duration(i)=3;
            j=j+1;        
        else
            duration(i)=1;
        end        
        j=j+1;
        i=i+1;    
    end
end

count=length(f0oggoi);
f0oggoi=f0oggoi(2:count);
frequencies=frequencies(2:count);
duration=duration(2:count);
count=length(f0oggoi);
amplitude=ones(count,1);

temp = strvcat('di  ','ke  ','Zw  ','Ni  ','Pa  ','Bou ','Ga  ','Di  ','Ke  ','Zw'' ','Ni'' ','Pa'' ','Bou''','Ga'' ','Di'' ');
f0oggoi_str = temp(f0oggoi,:);




%----------------------------------------------
%elegje poia f0ora einai      
%   .

function [scale2,frequencies2,j,f0oggosTe0hkeHfthora,f0oggos_f0oras]=check_f0ora(scale,mode,a,f0oggoi,frequencies,i,j,Ni_freq)

Di=8;
Ga=7;
Bou=6;
Pa=5;
Ni=4;
zw=3;
ke=2;
di=1;

if a(j)==' ',
    j=j+1;
else
    temp=input('Prin thn f0ora mpainei keno! Pata CTRL-C');
end

f0oggos_f0oras = -100;
f0oggosTe0hkeHfthora = -100;

%check f0ora (ED Fthora 97)!
switch a(j)
    case {'d','D','z','Z'}      %  -   ,           .
        f0oggos_f0oras = Ni;   
        mode=8;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;   
    case {'a','A','f','F'}      %  -   ,           .
        f0oggos_f0oras = Pa;   
        mode=8;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;   
    case {'h','H'}              %  -   ,           .
        f0oggos_f0oras = Ga;   
        mode=8;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;   
    case {'s','S','j','J'}      %  -   ,           .
        f0oggos_f0oras = Di;
        mode=8;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;   
    case {'w','W','2','@'}      %   (') -   ,             .
        if j ~= length(a),
            if a(j+1)==' ' & ( a(j+2)=='B' | a(j+2)=='b'),
                f0oggos_f0oras = Bou;
                j=j+2;
            else
                f0oggos_f0oras = Di;
            end
        else
            f0oggos_f0oras = Di;
        end
        mode=2;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;    
    case {'1','!','q','Q'}       % (. )  -   ,           .
        f0oggos_f0oras = Pa;   
        mode=6;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;           
    case {'6','^','y','Y'}      %  (. ): -   ,           .
        f0oggos_f0oras = Di;   
        mode=6;                
        [scale2,j,f0oggosTe0hkeHfthora] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq);
        frequencies2=frequencies;           
    case {'0',')','p','P'}      % 
        %apla alloiwse thn hdh uparxousa klimaka.
        f0oggos=f0oggoi(length(f0oggoi)); %f0oggos ston opoio te0hke h f0ora.
        if f0oggos==6 | f0oggos==10,	%Bou | Zw'
            scale2=get_scale(mode,Ni_freq);	%return to the mode scale (in case some other enarmonios was set before).
            scale2(f0oggos)=scale(f0oggos-1)*256/243;
            frequencies2=frequencies;
            frequencies2(length(frequencies2))=scale2(f0oggos);
            j=j+1;
        elseif f0oggos==7,	%Ga
            scale2=get_scale(mode,Ni_freq);	%return to the mode scale (in case some other enarmonios was set before).
            scale2(f0oggos-1)=scale(f0oggos-2)*9/8;		%ton Bou kanton 9/8*Pa
            frequencies2=frequencies;   %          ,    ,
                                        %     .  scale2    .
            j=j+1;      
        else
            temp=input('Enarmonios mexri twra mono gia ton Bou, Ga, Zw''! Pata CTRL-C');      
        end    
    case {'8','*','i','I'}      % ,    -.
        f0oggos=f0oggoi(end);   %f0oggos ston opoio te0hke h f0ora.
        if f0oggos~=Di | mode~=8,
            input('check xroa zugo, ctrl-c');
        end
        scale2=get_scale(mode,Ni_freq);	%
        scale2(Pa) = scale2(Pa)*(256/243);  %9/8 * 256/243
        scale2(Ga) = scale2(Ga)*(16/15);  %16/15 * 16/15
        j=j+1;
        frequencies2=frequencies;        
    case {'9','(','o','O'}      % ,    -.
        f0oggos=f0oggoi(end);   %f0oggos ston opoio te0hke h f0ora.
        if f0oggos~=Di | mode~=8,
            input('check xroa kliton, ctrl-c');
        end
        scale2=get_scale(mode,Ni_freq);	%
        scale2(Bou) = scale2(Bou)*(81/80);  %10/9 * 81/80
        scale2(Ga) = scale2(Di)/(25/24);    %Di - 4tmhmata
        j=j+1;
        frequencies2=frequencies;        
    otherwise
        temp=input('Meta to keno, prepei na baleis f0ora! Pata CTRL-C');
end    



%--------------------------------------------
%    

function f0oggoi=check_f0oggo_f0oras(a,j)

%check f0oggo (ED Fthora 97)!
switch a(j+1)
    case 'c'            %katw Ni
        f0oggoi=4;
    case 'v'
        f0oggoi=5;
    case 'b'
        f0oggoi=6;
    case 'n'
        f0oggoi=7;
    case 'm'
        f0oggoi=8;
    case ','
        f0oggoi=9;
    case '.'
        f0oggoi=10;  %panw Zw'.
    otherwise 
        temp=input('Prepei na baleis bash (Ni-Zw'')! Pata CTRL-C');
end



%-------------------------------------------------
%ChangeScaleAccording2f0ora
%    f0oggos,     f0oggos_f0oras.

function [scale2,j,f0oggos] = ChangeScaleAccording2f0ora(f0oggos_f0oras,mode,j,f0oggoi,scale,Ni_freq)

f0oggos=f0oggoi(end);    %f0oggos ston opoio te0hke h f0ora.
scale2=get_scale(mode,Ni_freq);	%return to the mode scale (in case some other enarmonios was set before).
a = scale2(f0oggos_f0oras)/scale(f0oggos);
temp=scale2/a;            %         .
scale2=700*ones(length(scale2),1);  %           (   ).
if f0oggos<f0oggos_f0oras,
    scale2(1:end-(f0oggos_f0oras-f0oggos)) = temp(f0oggos_f0oras-f0oggos+1:end);
else
    scale2(f0oggos-f0oggos_f0oras+1:end) = temp(1:end-(f0oggos-f0oggos_f0oras));            
end
j=j+1;        





%--------function to create the frequencies of each hxo!
%ison h suxnothta tou Ni.

function scale=hxos2freq(hxos,ison)

if hxos==2,
    nums=[
        1.06666666666667
        1.171875
        1.06666666666667
        1.125
        1.06666666666667
        1.171875			%Ke-Zw' 75/64
        1.06666666666667	%Di-Ke 16/15
        1.125			    %Ga-Di 9/8
        1.06666666666667
        1.171875
        1.06666666666667	%Ni-Pa 16/15
        1.125			    %zw-Ni 9/8
        1.06666666666667	%ke-zw 16/15
        1.171875   		    %di-ke  75/64        
    ];
elseif hxos==3,
    nums=[
        1.125               %'-'    9/8
        1.05349794238683    %'-'   256/243
        1.125               %'-'   9/8     
        1.125               %-'     9/8
        1.125               %'-'    9/8     
        1.05349794238683    %-'     256/243
        1.125               %-      9/8
        1.125               %-      9/8     
        1.05349794238683    %-     256/243
        1.125               %-     9/8
        1.125               %-      9/8     
        1.125               %-      9/8
        1.05349794238683    %-      256/243        
        1.125               %-      9/8        
    ];    
elseif hxos==6,
    nums=[
        1.215               %Ga-Di'
        1.05349794238683
        1.125
        1.04166666666667
        1.215               %Zw'-Ni'
        1.05349794238683
        1.125
        1.04166666666667
        1.215               %Bou-Ga 243/200
        1.05349794238683    %Pa-Bou 256/243
        1.125               %Ni-Pa 9/8
        1.04166666666667    %zw-Ni 25/24
        1.215               %ke-zw 243/200
        1.05349794238683    %di-ke = 256/243        
    ];
elseif hxos==8,
    nums=[
        1.125               %Di'
        1.06666666666667
        1.11111111111111
        1.125
        1.06666666666667
        1.11111111111111
        1.125
        1.125
        1.06666666666667
        1.11111111111111
        1.125               %Ni
        1.06666666666667    %zw 16/15
        1.11111111111111    %ke 10/9
        1.125               %di 9/8        
    ];
end

scale=zeros(15,2);
scale(:,1)=[12:-1:1, -1:-1:-3]';        %katw Di - Di', 1(ena)->Ni  .

scale(15-3,2)=ison;
for i=11:-1:1,
    scale(i,2)=scale(i+1,2)*nums(i);
end
for i=13:15,
    scale(i,2)=scale(i-1,2)/nums(i-1);
end



%----------
%scale is a 2-column vector!
%scale2 is a column vector!

function scale2=get_scale(mode,Ni_freq)

scale=hxos2freq(mode,Ni_freq);     % get the frequencies for the hxo.
% klimaka=print_klimaka(scale)
scale=[ scale];
scale_inv=scale(15:-1:1,:);
scale2=scale_inv(:,2);



%----------

function s=print_klimaka(scale,scaleold,f0oggosTe0hkeHfthora,f0oggos_f0oras)

global pdplogo;

if nargin == 2,
    f0oggosTe0hkeHfthora = -100;
    f0oggos_f0oras = -100;
end

global str_palianea;

temp=size(scale);
if temp(2)==1,
    a=scale(length(scale):-1:1);
else
    a=scale(:,2);
end

if nargin==2 | nargin==4,
    temp=size(scaleold);
    if temp(2)==1,    
        b=scaleold(length(scaleold):-1:1);
    else
        b=scaleold(:,2);
    end
end

sn1=strvcat('(1)','(q)','(a)','(z)','(x)','(c)','(v)','(b)','(n)','(m)','(,)','(.)','(/)','('')','(])');
s1 =strvcat('di','ke','zw','Ni','Pa','Bou','Ga','Di','Ke','Zw''','Ni''','Pa''','Bou''','Ga''','Di''');
s1=s1(15:-1:1,:);
sn1=sn1(15:-1:1,:);
s=[];
disp(pdplogo);
disp(' ');
if nargin ==1,
    for i=1:length(a),
        s=[s; sprintf('%s %s %8g              -/2: %8g',sn1(i,:),s1(i,:),a(i),a(i)/2);];
    end
else
    if f0oggosTe0hkeHfthora<0 | f0oggos_f0oras<0,
        disp(str_palianea);
        for i=1:length(a),
            stemp = sprintf('%s %s %8g  | %s %8g              -/2: %8g',sn1(i,:),s1(i,:),b(i),s1(i,:),a(i),a(i)/2);
            s=[s; stemp];
        end    
    else
        disp(str_palianea);
        sn1=strvcat('(1)','(q)','(a)','(z)','(x)','(c)','(v)','(b)','(n)','(m)','(,)','(.)','(/)','('')','(])');
        s1=strvcat('di','ke','zw','Ni','Pa','Bou','Ga','Di','Ke','Zw''','Ni''','Pa''','Bou''','Ga''','Di''');
        if f0oggos_f0oras <= f0oggosTe0hkeHfthora,
            s2 = strvcat('--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ');            
            s2(f0oggosTe0hkeHfthora:15,:) = s1(f0oggos_f0oras:15-f0oggosTe0hkeHfthora+f0oggos_f0oras,:);            
            s2(1+(f0oggosTe0hkeHfthora-f0oggos_f0oras):f0oggosTe0hkeHfthora-1,:) = s1(1:f0oggos_f0oras-1,:);
        else
            stt = strvcat('--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ','--  ');            
            s2 = [s1(f0oggos_f0oras-f0oggosTe0hkeHfthora+1:15,:); stt(1:f0oggos_f0oras-f0oggosTe0hkeHfthora,:)];
        end
        sn1=sn1(15:-1:1,:);
        s1=s1(15:-1:1,:);
        s2=s2(15:-1:1,:);        
        for i=1:length(a),
            stemp = sprintf('%s %s %8g  |  %s %8g              -/2: %8g',sn1(i,:),s1(i,:),b(i),s2(i,:),a(i),a(i)/2);
            s=[s; stemp];
        end            
    end
end



%--------------------------------------------------------------
% .         
%  (  mode).

function [frequencies2]=put_melwdikes_eljeis(f0oggoi,frequencies,startmode)

Di=8;
Ga=7;
Bou=6;
Pa=5;
Ni=4;
zw=3;
ke=2;
di=1;

frequencies2 = frequencies;

if startmode == 6, %  '
    
    ufesisGa_1 = (81/80)^2; %25/24 -> 304.13, 81/80 -> 312.89, (81/80)^2 -> 309.03;
    ufesisGa_2 = 81/80;
    
    %ufeseis ston Ga.
    pos=find(f0oggoi==Ga);
    for i=1:length(pos),
        poshere = pos(i);
        
        %     ,   .
        if poshere==1,
            frequencies2(poshere) = frequencies(poshere);            
            
        %  = 7 (=4),                .        
        elseif f0oggoi(poshere-1)<Ga & f0oggoi(poshere+1)<Ga,
            frequencies2(poshere) = frequencies(poshere)/ufesisGa_1;
            
        %  = 7 (=4),     ,,,.  
        elseif f0oggoi(poshere-1)==Di & f0oggoi(poshere+1)==Bou & f0oggoi(poshere+2)==Pa,
            frequencies2(poshere) = frequencies(poshere)/ufesisGa_2;
        end            
    end
    
    
else
    temp=input('      '' ! Pata CTRL-C');
end



%-------------------------------------------------------------------
%save data
function save_wav(scale,fs,nbits,period,armonikes_amplitude,ampl)

str1=input(' : ','s');

%save each f0oggo
for i = 1:15,    
    frequencies =[];
    duration = [];
    amplitude = [];
    
    frequencies(i)=scale(i);       
    duration(i)=1;
    amplitude(i)=1;
    
    y=[];
    for i=1:length(frequencies),
        t=0:1/fs:duration(i)*period-1/fs;
        waveform=zeros(1,length(t));
        for j=1:length(armonikes_amplitude),        
            waveform=waveform+ampl(j)*sin(2*pi*frequencies(i)*armonikes_amplitude(j,2)*t);
        end
        y=[y, amplitude(i)*waveform];
    end
    
    %write .wav
    s = sprintf('%s_%02d.wav',str1,i);
    wavwrite(y,fs,nbits,s);
    
%     %write .m3u
%     s3u = sprintf('%s_%02d.m3u',str1,i);
%     sp3 = sprintf('%s_%02d.mp3',str1,i);    
%     fid = fopen(s3u,'w');
%     fprintf(fid,sp3);
%     fclose(fid);    
end

ch1 = input('1:  , 2: ');

if ch1==1,    
    n1=input(' : ');
    n2=input(' : ');
    frequencies =[];
    duration = [];
    amplitude = [];
    
    %save klimaka
    for i = n1:n2,        
        frequencies(i)=scale(i);       
        duration(i)=1;
        amplitude(i)=1;
    end
    j=i+1;
    for i = n2-1:-1:n1,        
        frequencies(j)=scale(i);       
        duration(j)=1;
        amplitude(j)=1;
        j=j+1;
    end
    y=[];
    for i=1:length(frequencies),
        t=0:1/fs:duration(i)*period-1/fs;
        waveform=zeros(1,length(t));
        for j=1:length(armonikes_amplitude),        
            waveform=waveform+ampl(j)*sin(2*pi*frequencies(i)*armonikes_amplitude(j,2)*t);
        end
        y=[y, amplitude(i)*waveform];
    end
    
    %write .wav
    s = sprintf('%s_%02d-%02d.wav',str1,n1,n2);
    wavwrite(y,fs,nbits,s);
    
    %write .m3u
    % s3u = sprintf('%s_%02d-%02d.m3u',str1,n1,n2);
    % sp3 = sprintf('%s_%02d-%02d.mp3',str1,n1,n2);   
    % fid = fopen(s3u,'w');
    % fprintf(fid,sp3);
    % fclose(fid);    
    
else    
    frequencies =[];
    duration = [];
    amplitude = [];
    
    f0oggoitable = [8     6     7     8     9    10    11    10     9     8     7     6     5     4     8];
    duration     = [1     1     1     1     1     1     1     1     1     1     1     1     1     1     2];
        
    %save klimaka
    for i = 1:length(f0oggoitable),        
        frequencies(i)=scale(f0oggoitable(i));       
        amplitude(i)=1;
    end
    y=[];
    for i=1:length(frequencies),
        t=0:1/fs:duration(i)*period-1/fs;
        waveform=zeros(1,length(t));
        for j=1:length(armonikes_amplitude),        
            waveform=waveform+ampl(j)*sin(2*pi*frequencies(i)*armonikes_amplitude(j,2)*t);
        end
        y=[y, amplitude(i)*waveform];
    end
    
    %write .wav
    s = sprintf('%s_klimaka.wav',str1);
    wavwrite(y,fs,nbits,s);    
end



%ison = suxnothta tou Ni.
%scale is a 2-column vector!
%scale2 is a column vector!

function scale2 = load_special_scales(hxos,choice,ison)   

specialcase = -1;

if hxos == 30,          % 1881. 
    if choice=='1',     %diatonikh,  , ... . 14,16,22.
        nums = [    
            %Di'            
            1.125                        
            1.08
            1.09739368998628            
            1.125                 
            1.08
            1.09739368998628            
            1.125     
            1.125     
            1.08
            1.09739368998628
            1.125                        
            1.08                        %zw-Ni
            1.09739368998628            %ke-zw
            1.125                       %di-ke
            %di
        ];
    end            
elseif hxos == 31,          %. 
    if choice=='1',         %diatonikh, "" , . 28.
        nums = [    
            %Di' 
            1.125
            1.08641975308642
            1.09090909090909
            1.125
            1.08641975308642
            1.09090909090909
            1.125
            1.125
            1.08641975308642
            1.09090909090909
            1.125                       %-            
            1.08641975308642
            1.09090909090909
            1.125                       %di-ke
            %di
        ];
    end     
elseif hxos == 40,          %12-10-8 ktl.
       
    if choice=='1',             %1. Ni-12-10-8 -12-12-10-8 -Ni' (diatonic)
        sc = [12,     10,     8,      12,     12,     10,     8];    %diatonic, Ni-Ni'.
        nums1 = commas2scale(sc,sum(sc));        
        nums = [nums1(1:3), nums1, nums1(1:4)];         %gives in addition, di-ke,ke-zw,zw-Ni and Ni'-Pa',Pa'-Bou',Bou'-Ga',Ga'-Di'.        
        specialcase = -1; 
        nums = nums(end:-1:1);  %Ga'-Di' should be in 1st position.        
    elseif choice=='2',         %2. Ni-8 -14-8 -12-8 -14-8 -Ni' (neanes or "soft" chromatic)
        sc = [8,     14,     8,      12,     8,     14,     8];    %(neanes or "soft" chromatic).
        nums1 = commas2scale(sc,sum(sc));        
        nums = [nums1(2:4), nums1, nums1(4:7)];         %gives in addition, di-Ni = 14-8-12, Ni'-Di'=12-8-14-8.
        specialcase = -1;         
        nums = nums(end:-1:1);  %Ga'-Di' should be in 1st position.
    elseif choice=='3',         %3. Pa-6 -20-4 -12-6 -20-4 -Pa' (nexeanes or "hard" ("sintonos") chromatic)
        sc = [6,     20,     4,      12,     6,     20,     4];    
        nums1 = commas2scale(sc,sum(sc));        
        nums = [nums1(1:4), nums1, nums1(4:6)];         %gives in addition, di-Pa = 6-20-4-12, Pa'-Di'=12-6-20.
        specialcase = -1;         
        nums = nums(end:-1:1);  %Ga'-Di' should be in 1st position.
    elseif choice=='4',         %4. Ga-12-12-6 -12-12-12-6 Ga'  (enarmonion)
        sc = [12,     12,     6,      12,     12,     12,     6];    
        nums1 = commas2scale(sc,sum(sc));        
        nums = [nums1(2:7), nums1, nums1(1)];         %gives in addition, di-Ga = Di-Ga', Ga'-Di'=Ga-Di=12.
        specialcase = -1;         
        nums = nums(end:-1:1);  %Ga'-Di' should be in 1st position.
    elseif choice=='5',         %5. Ni-18-4 -16-4 -Di  (zygos)
        sc = [18,     4,     16,      4];    
        nums = commas2scale(sc,72);        
        startf = 4;
        endf = 8;
        multison = 1; 
        specialcase =1;         
    elseif choice=='6',         %6. Ni-12-14-12-4 -Di  (kliton)
        sc = [12,     14,     12,      4];    
        nums = commas2scale(sc,72);        
        startf = 4;
        endf = 8;
        multison = 1;
        specialcase =1;
    elseif choice=='7',         %7. Ga-20-4 -4 -14-Ni' (spathi)
        sc = [20,     4,     4,      14];    
        nums = commas2scale(sc,72);        
        startf = 7;
        endf = 11;
        multison =2^((12+10+8)/72);
        specialcase =1;
    end        
    
elseif hxos == 80,      %2-2-1 etc. (NON-BYZANTINE; for comparison)

    if choice=='1',        %2-2-1-2-2-2-1.    
        sc = [2,      2,      1,      2,      2,      2,      1];          %Western: C,D,E,F,G,A,B,C.;    %diatonic, Ni-Ni'.
        nums1 = commas2scale(sc,sum(sc));        
        nums = [nums1(1:3), nums1, nums1(1:4)];         %gives in addition, di-ke,ke-zw,zw-Ni and Ni'-Pa',Pa'-Bou',Bou'-Ga',Ga'-Di'.        
    end     
    
    nums = nums(end:-1:1);  %Ga'-Di' should be in 1st position.
    
end


if specialcase == -1,
    scale=zeros(15,2);
    scale(:,1)=[12:-1:1, -1:-1:-3]';        %katw Di - Di', 1(ena)->Ni  .    
    scale(15-3,2)=ison;
    for i=11:-1:1,
        scale(i,2)=scale(i+1,2)*nums(i);
    end
    for i=13:15,
        scale(i,2)=scale(i-1,2)/nums(i-1);
    end
    scaletemp=get_scale(8,ison);
    klimaka=print_klimaka(scale,scaletemp); disp(klimaka)
    scale_inv=scale(15:-1:1,:);
    scale2=scale_inv(:,2);
else
    scale2 = 700*ones(15,1);
    fr = [];
    fr(1) = ison * multison;
    for i=2:length(sc)+1,
        fr(i) = fr(i-1) * nums(i-1);
    end
    scale2(startf:endf) = fr;
end



function nums1 = commas2scale(sc,sumscale)

N = length(sc);
%get scale.
nums1 = []; 
for i = 1:N,  
    nums1(i) = 2^(sc(i)/sumscale);  %gives Ni-Pa,Pa-Bou,....,Zw-Ni' if N = 7.
end        